import { useComputed, useValue } from "@tldraw/state-react";
import { uniq } from "../utils/uniq.mjs";
import { useEditor } from "./useEditor.mjs";
function usePeerIds() {
  const editor = useEditor();
  const $userIds = useComputed(
    "userIds",
    () => uniq(editor.getCollaborators().map((p) => p.userId)).sort(),
    { isEqual: (a, b) => a.join(",") === b.join?.(",") },
    [editor]
  );
  return useValue($userIds);
}
export {
  usePeerIds
};
//# sourceMappingURL=usePeerIds.mjs.map
